<?php 
/**
* Extension of Codeigniter's {@link http://codeigniter.com/user_guide/helpers/form_helper.html form_helper}.
*
* @package direct-project-innovation-initiative
* @subpackage helpers
*/

load_libraries('Error_helper', 'Validator');
load_helpers('html');

/**
 * Hidden Input Field
 *
 * Generates hidden fields.  You can pass a simple key/value string or an associative
 * array with multiple values.
 *
 * @access	public
 * @param	mixed
 * @param	string
 * @return	string
 */
 
if ( ! function_exists('form_hidden'))
{
	function form_hidden($name, $value = '', $id = FALSE, $class = FALSE, $recursing = FALSE)
	{
		static $form;

		if ($recursing === FALSE)
		{
			$form = "\n";
		}

		if (is_array($name))
		{
			foreach ($name as $key => $val)
			{
				//if first param is array, and second is TRUE, assume we want the name to also be the id
				if($value === TRUE) { form_hidden($key, $val, $key, FALSE, TRUE); }
				//otherwise no id attribute will be added to these form elements
				else { form_hidden($key, $val, FALSE, FALSE, TRUE); }
			}
			return $form;
		}

		if ( ! is_array($value))
		{
			if($id === FALSE || strlen(trim($id)) <= 0) { $id_str = ''; } else { $id_str = ' id="'.$id.'" '; }
			if($class === FALSE || strlen(trim($class)) <= 0) { $class_str = ''; } else { $class_str = ' class="'.$class.'" '; }
			$form .= '<input type="hidden" name="'.$name.'"'. $id_str. $class_str . 'value="'.form_prep($value, $name).'" />'."\n";
		}
		else
		{
			foreach ($value as $k => $v)
			{
				$k = (is_int($k)) ? '' : $k;
				form_hidden($name.'['.$k.']', $v, $id, $class, TRUE);
			}
		}

		return $form;
	}
}

/**
* Returns the markup for a form validation error.
* Note that you'll need to close the validation error div after the form input.  
* @param string
* @return string
*/
function form_validation_error($error_message, $is_first = false){
	if(!is_string($error_message)) return should_be('string', $error_message);
	if(empty($error_message)) return '';
	if(!is_bool($is_first)) return should_be('boolean', $is_first);
	
	$class = 'validation_error message';
	if($is_first)
		$class .= ' absolute top';
		
	return '<div class="validation_error"><div class="'.$class.'"><a href="#">'.$error_message.'</a></div>';
}

function ajax_validation_error($id, $is_first){
	if(!is_bool($is_first)) return should_be('boolean', $is_first);
	
	$class = $id.'_error message';
	if($is_first)
		$class .= ' absolute top';
		
	return '<div class="'.$id.'_error"><div class="'.$class.'"><a id="'.$id.'_message" href="#"></a></div>';
}

/**
* Generates the markup for a form input, including the markup for its error message.
*
* Additionally, defaults to using the name of the field as an id if no id is provided.
*
* @param string Name of the form input
* @param string|array The value of the form input *or* an array of values for the form, keyed by field name
* @param string|array The error message for the form field *or* an array of error messages for the form, keyed by field name
* @param array The attributes for the form field
* @param boolean 
*/
function validated_form_input($name, $value, $error_message, $attributes = array(), $is_first=false){
	if(!validates_as('nonempty_string', $name)) return should_be('nonempty string', $name);
	
	//allow developer to pass in an entire array of values or error messages - they'll usually be dealing with an array of vals
	if(is_array($value)) $value = element($name, $value);
	if(is_array($error_message)) $error_message = element($name, $error_message);
	
	//finish validating that we have acceptable values for the rest of the parameters
	if(!empty($value) && !is_string($value)) return should_be('string', $value);
	if(!empty($error_message) && !is_string($error_message)) return should_be('string', $error_message);
	if(!is_array($attributes)) return should_be('array', $attributes);
	if(!is_bool($is_first)) return should_be('boolean', $is_first);
	
	//default to an id that's the same as the form name - makes it less likely people will forget to be 508-compliant with the label
	$default_attributes = array('id' => $name, 'class' => 'text-input');
	$attributes = merge_attributes($default_attributes, $attributes);
	
	//generate the actual markup
	$markup = form_input($name, $value, attributes_to_string($attributes));
	if(!empty($error_message)){
		$markup = form_validation_error($error_message, $is_first).$markup.'</div>';
	}
	
	return $markup;
}

/**
* Generates the markup for a form input, including the markup for its error message.
*
* Additionally, defaults to using the name of the field as an id if no id is provided.
*
* @param string Name of the form input
* @param string|array The value of the form input *or* an array of values for the form, keyed by field name
* @param string|array The error message for the form field *or* an array of error messages for the form, keyed by field name
* @param array The attributes for the form field
* @param boolean 
*/
function ajax_validated_form_input($name, $value, $attributes = array(), $is_first=false){
	if(!validates_as('nonempty_string', $name)) return should_be('nonempty string', $name);
	
	//allow developer to pass in an entire array of values  - they'll usually be dealing with an array of vals
	if(is_array($value)) $value = element($name, $value);
	if(!empty($value) && !is_string($value)) return should_be('string', $value);
	if(!is_array($attributes)) return should_be('array', $attributes);
	if(!is_bool($is_first)) return should_be('boolean', $is_first);
	
	//default to an id that's the same as the form name - makes it less likely people will forget to be 508-compliant with the label
	$default_attributes = array('id' => $name, 'class' => 'text-input');
	$attributes = merge_attributes($default_attributes, $attributes);
	
	//generate the actual markup
	return ajax_validation_error($attributes['id'], $is_first).form_input($name, $value, attributes_to_string($attributes)).'</div>';
}